from aardvark_py import *
from config import *

#==============================================================================
# SETUP AARDVARK
#==============================================================================

def setup_aardvark():

	INT1_PIN = 0
	
	# DETECT AARDVARK IN THE SYSTEM, ASSUME ONLY ONE EXISTS

	print "Detecting Aardvark adapters..."

	# Find all the attached devices
	(num, ports, unique_ids) = aa_find_devices_ext(16, 16)

	if num > 0:
		print "%d device(s) found:" % num

		# Print the information on each device
		for i in range(num):
			port      = ports[i]
			unique_id = unique_ids[i]

			# Determine if the device is in-use
			inuse = "(avail)"
			if (port & AA_PORT_NOT_FREE):
				inuse = "(in-use)"
				port  = port & ~AA_PORT_NOT_FREE

			# Display device port number, in-use status, and serial number
			print "    port = %d   %s  (%04d-%06d)" % \
				(port, inuse, unique_id / 1000000, unique_id % 1000000)

	else:
		print "No devices found."
		sys.exit()

	# !!! - for now open one and only device

	handle = aa_open(ports[0])
	if (handle <= 0):
		print "Unable to open Aardvark device on port %d" % port
		print "Error code = %d" % handle
		sys.exit()

	if INTERFACE == I2C:

		# Configure part enabling I2C and making SPI pins (MOSI, MISO) GPIO
		aa_configure(handle,  AA_CONFIG_GPIO_I2C)
		# no pull-ups
		aa_gpio_pullup(handle, 0x00)
		# MISO <= INT1, 
		# MOSI => Startup indicate (of getting into Active Mode, or the first 
		# triggered reading)
		# aa_gpio_direction(handle, AA_GPIO_MOSI)
		# Clear all output pins
		# aa_gpio_set(handle, 0x00)

		# Enable the I2C bus pullup resistors (2.2k resistors).
		# This command is only effective on v2.0 hardware or greater.
		# The pullup resistors on the v1.02 hardware are enabled by default.
		if ENABLE_PULLUPS == True:
			aa_i2c_pullup(handle, AA_I2C_PULLUP_BOTH)

		# Set the bitrate
		bitrate = aa_i2c_bitrate(handle, BITRATE)
		print "Bitrate set to %d kHz" % BITRATE

		INT1_PIN = AA_GPIO_MISO

	elif INTERFACE == SPI:
		
		# Configure part enabling SPI and making I2C pins (SDA, SCL) GPIO
		aa_configure(handle,  AA_CONFIG_SPI_GPIO )
		# no pull-ups
		aa_gpio_pullup(handle, 0x00)

		aa_spi_configure( handle, AA_SPI_POL_RISING_FALLING, \
				AA_SPI_PHASE_SAMPLE_SETUP, AA_SPI_BITORDER_MSB )

		aa_spi_bitrate( handle, BITRATE )

		aa_spi_master_ss_polarity( handle, AA_SPI_SS_ACTIVE_LOW )

		INT1_PIN = AA_GPIO_SCL

		# setup GPIO:
		# make SDA output
		aa_gpio_direction(handle, 0x00) # all inputs
		# Clear all output pins
		aa_gpio_set(handle, 0x00)		

	else:

		print "Incorrect interface specified in config.py"
		print "Exiting..."
		sys.exit()

	return (handle, INT1_PIN)
